
IF EXISTS (SELECT * FROM dbo.SYSOBJECTS WHERE XTYPE = 'U' AND NAME = 'RC_CLI_CONV_RC_CLI_SALDO_PENDENTE')
	BEGIN
		DROP TABLE RC_CLI_CONV_RC_CLI_SALDO_PENDENTE
	END
 
GO 

CREATE TABLE [dbo].[RC_CLI_CONV_RC_CLI_SALDO_PENDENTE](
	[CD_EMP] [int] NOT NULL,
	[CD_CLI] [int] NOT NULL,
	[CD_CONV] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_RC_CLI_CONV_RC_CLI_SALDO_PENDENTE] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_CLI] ASC,
	[CD_CONV] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[RC_CLI_CONV_RC_CLI_SALDO_PENDENTE] ADD  CONSTRAINT [DF_RC_CLI_CONV_RC_CLI_SALDO_PENDENTE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
GO

ALTER TABLE [dbo].[RC_CLI_CONV_RC_CLI_SALDO_PENDENTE] ADD  CONSTRAINT [DF_RC_CLI_CONV_RC_CLI_SALDO_PENDENTE_CD_CLI]  DEFAULT ((0)) FOR [CD_CLI]
GO

ALTER TABLE [dbo].[RC_CLI_CONV_RC_CLI_SALDO_PENDENTE] ADD  CONSTRAINT [DF_RC_CLI_CONV_RC_CLI_SALDO_PENDENTE_CD_CONV]  DEFAULT ((0)) FOR [CD_CONV]
GO

ALTER TABLE [dbo].[RC_CLI_CONV_RC_CLI_SALDO_PENDENTE]  WITH CHECK ADD  CONSTRAINT [FK_RC_CLI_CONV_RC_CLI_SALDO_PENDENTE_RC_CLI_CONV_RC_CLI] FOREIGN KEY([CD_EMP], [CD_CONV], [CD_CLI])
REFERENCES [dbo].[RC_CLI_CONV_RC_CLI] ([CD_EMP], [CD_CONV], [CD_CLI])
ON UPDATE CASCADE
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[RC_CLI_CONV_RC_CLI_SALDO_PENDENTE] CHECK CONSTRAINT [FK_RC_CLI_CONV_RC_CLI_SALDO_PENDENTE_RC_CLI_CONV_RC_CLI]
GO


